#ifndef _KEYS_H
#define _KEYS_H

/*

	FIFO Key Queue System
	by Mauro Grassi, 2007-2010

*/

#define KEY_BUFFER_SIZE     				4

#define KEYS_IP								1

#define NO_KEY								0xFF
#define KEY_SHORT							0x10
#define KEY_LONG							0x20

#define KEY_SCAN_PERIOD						40
#define KEY_SCAN_PERIOD_HOLDOFF_SHORT		30
#define KEY_SCAN_PERIOD_HOLDOFF_LONG		40

#define KEYPRESSED_LIMIT					6
#define KEYPRESSED_THRESHOLD				0

#define KEYSTATE_INITIAL					0
#define KEYSTATE_ENTERKEY					1
#define KEYSTATE_HOLDOFF					2

#define KEY_INITIAL_DEBOUNCE				1

void 								initKeys(void);
unsigned char 						getKey(void);
void 								putKey(unsigned char k);
void 								setKeysTimer(unsigned char on);
void 								setKeysComparator(unsigned char on);
void 								clearKeys(void);
void 								powerKeys(unsigned char on);

extern volatile unsigned char 		keyBuffer[KEY_BUFFER_SIZE];
extern volatile unsigned char		keyFull;
extern volatile unsigned char		keyGetPtr;
extern volatile unsigned char		keyPtr;
extern volatile unsigned int		keyCountTimer;
extern volatile unsigned int		keyPressedCount;
extern volatile unsigned char		keyState;
extern volatile unsigned char		keyInitialDebounce;

#endif
